const py0 = 0;
const py1 = 720;
const py2 = -100;
const py3 = 360;

function courbe_bezier(t) {
    const u = 1 - t;
    const tt = t * t;
    const uu = u * u;
    const uuu = uu * u;
    const ttt = tt * t;

    const y = uuu * py0 + 3 * uu * t * py1 + 3 * u * tt * py2 + ttt * py3;

    return y;
}

$(document).ready(function() {
    // fleche qui descent avec un rotation gauche/droite
    function animateImage() {
        $(".scroll-link").animate({
            'top': "360px",
        }, {
        duration: 2000, 
        step: function(now, fx) {
            t = Math.min(1, now / 360);
            const posY = courbe_bezier(t);
            $(this).css('transform', 'translateY('+posY+'px)');
        },
        complete: function() {
            $(this).css('top', '0px');
            animateImage();
        }});
    }
    animateImage();

    // images en grise avec un rotation pour voir l'image en couleur
    var images = $('#options1 img');
    var index = 0;

    setInterval(function() {
        images.css('filter', 'grayscale(100%)');
        $(images[index]).css('filter', 'grayscale(0%)');
        index = (index + 1) % images.length;
    }, 500);

    // Aggrandi le texte du titre
    $("#agranditexte").hover(
        function() {
            $(this).css('font-size', '150%');
        },
        function() {
            $(this).css('font-size', '100%');
        }
    );

    // prepare l'aggrandi un lettre du titre si la souris et dessus
    const headings = document.querySelectorAll('h1'); 
    headings.forEach(heading => {
        let text = heading.innerText;
        let html = '';
        html += '<span id="niveautext"> </span>' ; // mise en forme du premier caracter pour eviter un sursaut quand on passe sur les caractères suivants
        for (let i = 0; i < text.length; i++) {
            if (text[i] !== ' ') {
                html += '<span>' + text[i] + '</span>';
            } else {
                html += ' ';
            }
        }

        heading.innerHTML = html;
    });
    // mise en forme du 1er caractère (espace) afin de ne pas avoir un saut quand on change de caractère avec la souris
    $('#niveautext').css('font-size', '130%');
    $('#agrandicar span').hover(function() {
        $(this).css('font-size', '120%');
    }, function() {
        $(this).css('font-size', '100%');
    });
});